<?php

namespace App\supplier1;

use App\Services\LogManager;
use Curl\Curl;

class ImageDownloader {
    private $logManager;
    private $curl;
    private $outputDir;

    public function __construct() {
        $this->logManager = new LogManager();
        $this->curl = new Curl();
        $this->outputDir = $_ENV['IMAGE_OUTPUT_DIR'];

        // Ensure the output directory exists
        if (!is_dir($this->outputDir)) {
            mkdir($this->outputDir, 0777, true);
        }
    }

    public function handleImage($imageUrl, $title, $code) {
        if ($imageUrl === 'https://www.my-advantage.co.uk/images/default/400x400.jpg') {
            $this->logManager->logError("$code uses the default blank image", 'imagedownloader', 'supplier1');
            return $imageUrl;
        }

        $imageUrl = preg_replace("/http/", "https", $imageUrl);
        $imageFileName = $this->generateImageFileName($title, $code, $imageUrl);
        $imageFilePath = $this->outputDir . '/' . $imageFileName;

        if (!file_exists($imageFilePath)) {
            $this->logManager->logInfo("Downloading image for $code from: $imageUrl", 'imagedownloader', 'supplier1');
            $this->downloadImage($imageUrl, $imageFilePath);
        } else {
            $this->logManager->logInfo("Image already exists for $code: $imageFilePath", 'imagedownloader', 'supplier1');
        }

        return 'catalog/product-images/' . $imageFileName;
    }

    private function generateImageFileName($title, $code, $imageUrl) {
        $imageFileName = preg_replace("/\s/", "-", strtolower($title));
        $imageFileName = str_replace('/', "-", $imageFileName);
        $imageFileName = preg_replace("/[^a-z0-9-\.]/", "", $imageFileName);
        $imageFileName = str_replace('---', "-", $imageFileName);
        $imageFileName = $code . "-" . $imageFileName . "." . strtolower(pathinfo(parse_url($imageUrl)['path'], PATHINFO_EXTENSION));
        return $imageFileName;
    }

    private function downloadImage($url, $filePath) {
        $this->curl->setUserAgent('Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1)');
        $this->curl->setOpt(CURLOPT_SSL_VERIFYPEER, false);
        $this->curl->setOpt(CURLOPT_SSL_VERIFYHOST, false);
        $this->curl->download($url, $filePath);

        if ($this->curl->error) {
            $this->logManager->logError('Error: ' . $this->curl->errorCode . ': ' . $this->curl->errorMessage, 'imagedownloader', 'supplier1');
        } else {
            $this->logManager->logInfo('Image downloaded successfully: ' . $filePath, 'imagedownloader', 'supplier1');
        }
    }
}
